<?php

// Database connection parameters
$hostname = 'localhost';
$username = 'root';
$password = 'ashdjsahufqgfeq'; // Replace with your actual password
$database = 'IPS';

// Connect to the database
$mysqli = new mysqli($hostname, $username, $password, $database);

// Check for connection errors
if ($mysqli->connect_error) {
    die('Connect Error (' . $mysqli->connect_errno . ') ' . $mysqli->connect_error);
}

// Content-Type header to ensure output is displayed as plain text
header('Content-Type: text/plain');

// Query and output blocked IPs
$blockedQuery = "SELECT ip_address, reason, (UNIX_TIMESTAMP(timestamp) + expire_time - UNIX_TIMESTAMP()) AS expire_time FROM blocked WHERE UNIX_TIMESTAMP(timestamp) + expire_time - UNIX_TIMESTAMP() > 0";
$blockedResult = $mysqli->query($blockedQuery);

if ($blockedResult) {
    while ($row = $blockedResult->fetch_assoc()) {
        $ip = $row['ip_address'];
        $expireTime = $row['expire_time'];
        $reason = addslashes($row['reason']); // Escape special characters in the reason
        echo "ipset add myblacklist $ip timeout $expireTime comment '$reason'\n";
    }
} else {
    echo "Error retrieving blocked IPs: " . $mysqli->error . "\n";
}

// Query and output whitelisted IPs
$whitelistQuery = "SELECT ip_address FROM whitelisted";
$whitelistResult = $mysqli->query($whitelistQuery);

if ($whitelistResult) {
    while ($row = $whitelistResult->fetch_assoc()) {
        $ip = $row['ip_address'];
        // For each whitelisted IP, remove it from 'myblacklist' and add it to 'whitelist'
        echo "ipset del myblacklist $ip\n";
        echo "ipset add whitelist $ip\n";
    }
} else {
    echo "Error retrieving whitelisted IPs: " . $mysqli->error . "\n";
}

// Close the database connection
$mysqli->close();

?>

