<?php

// Database connection parameters
$hostname = 'localhost';
$username = 'root';
$password = 'ashdjsahufqgfeq'; // Replace with your actual password
$database = 'IPS';

// Connect to the database
$mysqli = new mysqli($hostname, $username, $password, $database);

// Check for connection errors
if ($mysqli->connect_error) {
    die('Connect Error (' . $mysqli->connect_errno . ') ' . $mysqli->connect_error);
}

// Function to validate an IP address (IPv4 or IPv6)
function isValidIP($ipAddress) {
    return filter_var($ipAddress, FILTER_VALIDATE_IP) !== false;
}

// Function to check if an IP address is already blocked or whitelisted
function ipExists($ipAddress, $table) {
    global $mysqli;
    
    $ipAddress = $mysqli->real_escape_string($ipAddress);
    $query = "SELECT * FROM $table WHERE ip_address = '$ipAddress'";
    $result = $mysqli->query($query);
    
    return $result->num_rows > 0;
}

// Function to insert data into the 'blocked' table
function insertBlocked($ipAddress, $reason = null, $expireTime = null) {
    global $mysqli;

 // Validate IP address
    if (!isValidIP($ipAddress)) {
        echo "Error: Invalid IP address format.\n";
        return;
    }
    
    if (ipExists($ipAddress, 'blocked')) {
        echo "IP address already blocked.\n";
        return;
    }
    
    $ipAddress = $mysqli->real_escape_string($ipAddress);
    $reason = $reason ? "'" . $mysqli->real_escape_string($reason) . "'" : 'NULL';
    $expireTime = $expireTime ? intval($expireTime) : 'NULL';
    
    $query = "INSERT INTO blocked (ip_address, reason, expire_time) VALUES ('$ipAddress', $reason, $expireTime)";
    $result = $mysqli->query($query);
    
    if (!$result) {
        die('Error: ' . $mysqli->error);
    }
    
    echo "Blocked record inserted successfully.\n";
}

// Function to insert data into the 'whitelisted' table and remove from 'blocked' if exists
function insertWhitelisted($ipAddress) {
    global $mysqli;
    
// Validate IP address
    if (!isValidIP($ipAddress)) {
        echo "Error: Invalid IP address format.\n";
        return;
    }

    // First, remove the IP from the blocked table if it exists
    $ipAddress = $mysqli->real_escape_string($ipAddress);
    $deleteQuery = "DELETE FROM blocked WHERE ip_address = '$ipAddress'";
    $mysqli->query($deleteQuery);
    if ($mysqli->affected_rows > 0) {
        echo "IP address removed from blocked list.\n";
    }

    // Check if the IP address is already in the whitelisted table
    if (ipExists($ipAddress, 'whitelisted')) {
        echo "IP address already whitelisted.\n";
        return;
    }
    
    // If not, insert it into the whitelisted table
    $insertQuery = "INSERT INTO whitelisted (ip_address) VALUES ('$ipAddress')";
    $result = $mysqli->query($insertQuery);
    
    if (!$result) {
        die('Error: ' . $mysqli->error);
    }
    
    echo "Whitelisted record inserted successfully.\n";
}


// Function to display/search blocked or whitelisted IP addresses with conditional display for whitelisted IPs
// Function to display/search blocked or whitelisted IP addresses with remaining block time calculation
function searchIP($searchTerm = '') {
    global $mysqli;
    
    // Adjust the query to fetch 'timestamp' and calculate 'expire_time'
    $searchTerm = $mysqli->real_escape_string($searchTerm);
    $queryBlocked = "SELECT ip_address, reason, timestamp, expire_time FROM blocked WHERE ip_address LIKE '%$searchTerm%'";

    // Execute the query for blocked IPs
    $resultBlocked = $mysqli->query($queryBlocked);
    if ($resultBlocked->num_rows > 0) {
        echo "Blocked IPs:\n";
        while ($row = $resultBlocked->fetch_assoc()) {
            // Calculate the remaining block time
            $blockAddedTime = strtotime($row['timestamp']);
            $expireSeconds = $row['expire_time'];
            $currentTime = time();
            $expireTime = $blockAddedTime + $expireSeconds;
            $remainingTime = $expireTime - $currentTime;

            if ($remainingTime > 0) {
                echo $row['ip_address'] . " | Reason: " . $row['reason'] . " | Remaining block time: " . $remainingTime . " seconds\n";
            } else {
                echo $row['ip_address'] . " | Reason: " . $row['reason'] . " | Block expired\n";
            }
        }
    } else {
        echo "No blocked IPs found matching the search term.\n";
    }
    
    // Query and display for whitelisted IPs remains unchanged
    $queryWhitelisted = "SELECT * FROM whitelisted WHERE ip_address LIKE '%$searchTerm%'";
    $resultWhitelisted = $mysqli->query($queryWhitelisted);
    if ($resultWhitelisted->num_rows > 0) {
        echo "\nWhitelisted IPs:\n";
        while ($row = $resultWhitelisted->fetch_assoc()) {
            echo $row['ip_address'] . "\n";
        }
    }
}

// Check if the required parameters are provided
if (isset($_GET['action'])) {
    switch ($_GET['action']) {
        case 'block':
            if (isset($_GET['ip'])) {
                $ipAddress = $_GET['ip'];
                $reason = isset($_GET['reason']) ? $_GET['reason'] : null;
                $expireTime = isset($_GET['expire_time']) ? $_GET['expire_time'] : null;
                insertBlocked($ipAddress, $reason, $expireTime);
            } else {
                die('Error: IP address is required.');
            }
            break;
            
        case 'whitelist':
            if (isset($_GET['ip'])) {
                $ipAddress = $_GET['ip'];
                insertWhitelisted($ipAddress);
            } else {
                die('Error: IP address is required.');
            }
            break;
            
        case 'search':
            $searchTerm = isset($_GET['ip']) ? $_GET['ip'] : '';
            searchIP($searchTerm);
            break;
            
        default:
            die('Error: Invalid action.');
            break;
    }
} else {
    die('Error: Action parameter is missing.');
}

// Close the database connection
$mysqli->close();

?>

