<?php

// Directory containing the files
$directory = '/etc/filter-configs';

// Get the filename from the query parameter
$filename = isset($_GET['file']) ? $_GET['file'] : '';

// Security check to prevent directory traversal attacks
if (strpos($filename, '..') !== false) {
    die('Invalid file name.');
}

// Full path to the file
$filePath = $directory . '/' . $filename;

// Check if the file exists and is in the specified directory to prevent directory traversal
if (file_exists($filePath) && realpath($filePath) === $filePath) {
    // Set headers to download the file
    header('Content-Description: File Transfer');
    header('Content-Type: application/octet-stream');
    header('Content-Disposition: attachment; filename="' . basename($filePath) . '"');
    header('Expires: 0');
    header('Cache-Control: must-revalidate');
    header('Pragma: public');
    header('Content-Length: ' . filesize($filePath));
    flush(); // Flush system output buffer
    readfile($filePath);
    exit;
} else {
    // If no file is specified or file doesn't exist, list available files
    if ($handle = opendir($directory)) {
        while (false !== ($entry = readdir($handle))) {
            if ($entry != "." && $entry != "..") {
                // Output each filename on a separate line
                echo $entry . "\n";
            }
        }
        closedir($handle);
    }
}
?>

