<?php

// Database connection parameters
$hostname = 'localhost';
$username = 'root';
$password = 'ashdjsahufqgfeq';
$database = 'IPS';

// Connect to the database
$mysqli = new mysqli($hostname, $username, $password, $database);

// Check for connection errors
if ($mysqli->connect_error) {
    die('Connect Error (' . $mysqli->connect_errno . ') ' . $mysqli->connect_error);
}

// Query to get count of blocked IPs for each reason
$blocked_query = "SELECT reason, COUNT(*) AS count_blocked_ips FROM blocked GROUP BY reason ORDER BY count_blocked_ips DESC";
$blocked_result = $mysqli->query($blocked_query);

// Query to get count of whitelisted IPs
$whitelisted_query = "SELECT COUNT(*) AS count_whitelisted_ips FROM whitelisted";
$whitelisted_result = $mysqli->query($whitelisted_query);

// Close the database connection
$mysqli->close();

?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Blocked and Whitelisted IPs</title>
    <style>
        table {
            border-collapse: collapse;
            width: 50%;
        }
        th, td {
            border: 1px solid #dddddd;
            text-align: left;
            padding: 8px;
        }
        th {
            background-color: #f2f2f2;
        }
    </style>
</head>
<body>

<h2>Blocked IPs</h2>
<table>
    <tr>
        <th>Reason</th>
        <th>Count</th>
    </tr>
    <?php
    // Display blocked IPs table
    if ($blocked_result->num_rows > 0) {
        while ($row = $blocked_result->fetch_assoc()) {
            echo "<tr><td>{$row['reason']}</td><td>{$row['count_blocked_ips']}</td></tr>";
        }
    } else {
        echo "<tr><td colspan='2'>No blocked IPs found</td></tr>";
    }
    ?>
</table>

<h2>Whitelisted IPs</h2>
<table>
    <tr>
        <th>Count</th>
    </tr>
    <?php
    // Display whitelisted IPs table
    if ($whitelisted_result->num_rows > 0) {
        $row = $whitelisted_result->fetch_assoc();
        echo "<tr><td>{$row['count_whitelisted_ips']}</td></tr>";
    } else {
        echo "<tr><td>No whitelisted IPs found</td></tr>";
    }
    ?>
</table>

</body>
</html>

